import QtQml 2.0

QtObject {
    // 显示测试过程中的数据
    property bool showTestData: true
    // 忽略测试失败项
    property bool ignoreFailedTestItem: true
    // 心跳检测时间（单位：ms）
    //property int hotplugInterval: 1000000
    // 硬件加速， openGL
    property bool hardwareAcceleration: true
    // 自动屏蔽坐标
    property bool autoDisableCoordinate: false

    // 界面语言，不填写则自动识别
    // "zh_CN" 简体中文
    // "en_US" 英文
    property string lang: "zh_CN"

    // 校准过程中，误操作超时时间
    property int calAutoCancelTime: 60000
    // 完成校准后，自动退出时间
    property int calFinishExitTime: 3000

    // 默认测试项
    property var defaultTestItems: [0,2,4,1,3,5]
    // 分开显示或者堆叠显示: true or false
    property bool displaySeparateModel: true
    // 测试项个数最大值，最多八个：只对信号分开显示有效
    property int testCount: 8

    // 默认切换到所需要的界面：
    //     0 升级界面
    //     1 测试界面
    //     2 信号图界面
    //     4 全屏画图界面
    //     5 设置界面
    //     6 关于界面设置
    property int currentIndex:0

    // 板载测试开关
	property bool switchOnboardTest:true
	
	// 启动全屏画图时打开坐标输出
	property bool isDrawOpenCoord: false
}
